 ; Ŀ
 ;   Fhk - Fixed Height Kill - make text styles not fixed height.          
 ;   Copyright 1995, 1999, 2001, 2004, 2005 by Rocket Software Ltd.        
 ;   What would the opposite of a zip program be?                          
 ; 
 (DEFUN C:FHK (/ tstyle nxstyl rew foon hite oblq sevt1 back upsd verti)
  (setvar "cmdecho" 0)
  (setq tstyle (getvar "textstyle"))
  (setq rew t)
 ; Ŀ
 ;   Step through the text styles.                                         
 ; 
  (while (setq nxstyl (tblnext "style" rew))
         (setq rew ())
         (setq hite (cdr (assoc 40 nxstyl)))    ; but force to zero
 ; Ŀ
 ;   If a style is fixed height and doesn't belong to an xref.             
 ; 
         (if (and (null (zerop hite))
                  (/= 16 (logand 16 (cdr (assoc 70 nxstyl)))))
             (progn
                  (setq stanam (cdr (assoc 2 nxstyl)))
                  (setq foon (cdr (assoc 3 nxstyl)))
                  (setq widt (cdr (assoc 41 nxstyl)))
                  (setq oblq (cdr (assoc 50 nxstyl)))
                  (setq sevt1 (cdr (assoc 71 nxstyl)))
                  (setq back (if (= 2 (logand sevt1 2)) "Y" "N"))
                  (setq upsd (if (= 4 (logand sevt1 4)) "Y" "N"))
                  (setq verti (if (= 4 (logand (cdr (assoc 70 nxstyl)) 4))
                                  "Y" "N"))
                  (command ".style"
                            stanam        ; name of text style
                            foon)         ; font name or filename (TTF or SHX)
 ; Ŀ
 ;   If the font file is available then we are still in the command.       
 ; 
                  (if (= 1 (logand 1 (getvar "cmdactive")))
                      (progn
                           (command 0             ; height of text
                                    widt          ; width factor
                                    oblq          ; obliquing angle
                                    back          ; backwards? [Yes/No]
                                    upsd)         ; upside-down? [Yes/No]
 ; Ŀ
 ;   If the font can be vertical, make it so or not so.                    
 ; 
                           (if (= 1 (logand 1 (getvar "cmdactive")))
                               (command verti)))  ; vertical? (if can be)
 ; Ŀ
 ;   If the font file was not available then print its name.               
 ; 
                      (princ (strcat foon "\n"))))))
 ; Ŀ
 ;   Ret the default style to the original one.                            
 ; 
  (setvar "textstyle" tstyle)
 (princ))